#ifndef _CASMCARD_H
#define _CASMCARD_H

//=================================================================//
//   
//    PC/SC SmartCard Application Programming Interface
//
//=================================================================//

#include "wintypes.h"
#include "pcsclite.h"

#ifdef __cplusplus
extern "C" {
#endif

#define IN
#define OUT
#define INOUT

//
// MessageId: SCARD_E_NON_CAS_READER
//
// MessageText:
//
//  The reader doesn't support. .
//
#define SCARD_E_NON_CAS_READER           ((DWORD)0x80100030L)

//
// MessageId: SCARD_E_NON_CAS_CONTEXT
//
// MessageText:
//
//  The context is incorrect.
//
#define SCARD_E_NON_CAS_CONTEXT          ((DWORD)0x80100031L)



////////////////////////////////////////////////////////////////////////////////
//
//  Service Manager Access Services
//
//      The following services are used to manage user and terminal contexts for
//      Smart Cards.
//

long 
CasEstablishContext(
	ULONG dwScope,
	const void *pvReserved1, 
	const void *pvReserved2, 
	long *phContext);

long 
CasReleaseContext(
	long hContext);

long 
CasSetTimeout(
	long hContext, 
	ULONG dwTimeout);

long CasConnect(long hContext,
	const char *szReader,
	ULONG dwShareMode,
	ULONG dwPreferredProtocols,
	long *phCard, ULONG *pdwActiveProtocol);

long CasReconnect(
	long hCard,
	ULONG dwShareMode,
	ULONG dwPreferredProtocols,
	ULONG dwInitialization, 
	ULONG *pdwActiveProtocol);

long 
CasDisconnect(
	long hCard, 
	ULONG dwDisposition);

long 
CasBeginTransaction(
	long hCard);

long 
CasEndTransaction(
	long hCard, 
	ULONG dwDisposition);

long 
CasCancelTransaction(
	long hCard);

long 
CasStatus(
	long hCard,
	char *mszReaderNames,
	ULONG *pcchReaderLen,
	ULONG *pdwState,
	ULONG *pdwProtocol,
	BYTE *pbAtr, 
	ULONG *pcbAtrLen);

long 
CasGetStatusChange(
	long hContext,
	ULONG dwTimeout,
	LPSCARD_READERSTATE_A rgReaderStates, 
	ULONG cReaders);

long
CasControl(
	long hCard,
	const BYTE *pbSendBuffer,
	ULONG cbSendLength,
	BYTE *pbRecvBuffer, 
	ULONG *pcbRecvLength);

long 
CasTransmit(
	long hCard,
	LPCSCARD_IO_REQUEST pioSendPci,
	const BYTE *pbSendBuffer,
	ULONG cbSendLength,
	LPSCARD_IO_REQUEST pioRecvPci,
	BYTE *pbRecvBuffer, 
	ULONG *pcbRecvLength);

long 
CasListReaderGroups(
	long hContext,
	char *mszGroups, 
	ULONG *pcchGroups);

long 
CasListReaders(
	long hContext,
	const char *mszGroups,
	char *mszReaders, 
	ULONG *pcchReaders);

long
CasCancel(
	long hContext);

long
CasGetRdrType(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,
	IN OUT LPDWORD pcbRecvLength);

//=================================================================//
//   
//    Only For Castles Serial EZ-Reader
//
//=================================================================// 
long
CasSetBaudRate(
    IN long hCard,
	IN BYTE BaudRate);

/* These are only for Castles Serial EZ-Reader */
#define CAS_SET_BAUD_RATE_38400 1
#define CAS_SET_BAUD_RATE_19200 2
#define CAS_SET_BAUD_RATE_9600 3
#define CAS_SET_BAUD_RATE_4800 4
#define CAS_SET_BAUD_RATE_2400 5
#define CAS_SET_BAUD_RATE_1200 6


//=================================================================//
//   
//    Memory Card Application Programming Interface
//
//=================================================================//

#ifndef _SCARD_M_STATUS
#define _SCARD_M_STATUS
#define SCARD_M_SUCCESS  NO_ERROR
#define SCARD_M_CARD_ABSENT     ((DWORD)0x80100078L)
#define SCARD_M_NO_RESPONSE     ((DWORD)0x80100079L)
#define SCARD_M_POWER_FAIL      ((DWORD)0x8010007AL)
#define SCARD_M_COMM_ERROR      ((DWORD)0x8010007BL)
#define SCARD_M_VERIFY_FAIL     ((DWORD)0x8010007CL)
#define SCARD_M_TYPE_ERROR      ((DWORD)0x8010007DL)
#define SCARD_M_COMMAND_ERROR   ((DWORD)0x8010007EL)
#define SCARD_M_COUNTER_EMPTY   ((DWORD)0x8010007FL)
#define SCARD_M_CARD_LOCKED     ((DWORD)0x80100080L)
#define SCARD_M_WRITE_ERROR     ((DWORD)0x80100081L)
#define SCARD_M_CHECK_ERROR     ((DWORD)0x80100082L)
#define SCARD_M_UNSUPPORTED     ((DWORD)0x80100083L)
#define SCARD_M_OTHER_FAIL      ((DWORD)0x80100084L)
#endif

/* Indicate the current protocol is SCARD_SYNCHRONIZE;
   that is, the card in the reader is a memory card.  
*/  
#define SCARD_PROTOCOL_SYNC 0x00000010

#ifndef MM_ADDRESS
#define MM_ADDRESS long
#endif
////////////////////////////////////////////////////////////////////////
//  SLE4442 Memory Card  API
////////////////////////////////////////////////////////////////////////

long
SLE4442_Read_Main_Memory(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,
	IN MM_ADDRESS aStartAddr,
	IN OUT LPDWORD pcbRecvLength);

long
SLE4442_Update_Main_Memory(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4442_Update_Main_MemoryA(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4442_Read_Protection_Memory(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer);

long
SLE4442_Write_Protection_Memory(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
	IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4442_Read_Security_Memory(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer);
//
long
SLE4442_Update_Security_Memory(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
	IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4442_Compare_Verification_Data(
    IN long hCard,
	IN BYTE PSC1,
	IN BYTE PSC2,
	IN BYTE PSC3);

////////////////////////////////////////////////////////////////////////
//  SLE4432 Memory Card  API
////////////////////////////////////////////////////////////////////////

long
SLE4432_Read_Main_Memory(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,
	IN MM_ADDRESS aStartAddr,
	IN OUT LPDWORD pcbRecvLength);

long
SLE4432_Update_Main_Memory(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4432_Update_Main_MemoryA(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4432_Read_Protection_Memory(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer);

long
SLE4432_Write_Protection_Memory(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
	IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);




////////////////////////////////////////////////////////////////////////
//  SLE4418 Memory Card  API
////////////////////////////////////////////////////////////////////////

long
SLE4418_Write_Data_With_Protect_Bit(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4418_Write_Data_With_Protect_BitA(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength); 
   
long
SLE4418_Write_Data_Without_Protect_Bit(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4418_Write_Data_Without_Protect_BitA(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4418_Write_Protect_Bit(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
	IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4418_Read_Data_With_Protect_Bit(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,
	OUT LPBYTE pbProtectBuffer,
	IN MM_ADDRESS aStartAddr,
	IN OUT LPDWORD pcbRecvLength);

long
SLE4418_Read_Data_Without_Protect_Bit(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,	
	IN MM_ADDRESS aStartAddr,
	IN OUT LPDWORD pcbRecvLength);


////////////////////////////////////////////////////////////////////////
//  SLE4428 Memory Card  API
////////////////////////////////////////////////////////////////////////

long
SLE4428_Write_Data_With_Protect_Bit(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength); 

long
SLE4428_Write_Data_With_Protect_BitA(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);
   
long
SLE4428_Write_Data_Without_Protect_Bit(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4428_Write_Data_Without_Protect_BitA(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4428_Write_Protect_Bit(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
	IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4428_Read_Data_With_Protect_Bit(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,
	OUT LPBYTE pbProtectBuffer,
	IN MM_ADDRESS aStartAddr,
	IN OUT LPDWORD pcbRecvLength);

long
SLE4428_Read_Data_Without_Protect_Bit(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,	
	IN MM_ADDRESS aStartAddr,
	IN OUT LPDWORD pcbRecvLength);

long
SLE4428_PSC_Verification(
    IN long hCard,
	IN BYTE PSC1,
	IN BYTE PSC2);

long
SLE4428_Mofify_PSC(
    IN long hCard,
	IN BYTE PSC1,
	IN BYTE PSC2);

////////////////////////////////////////////////////////////////////////
//  SLE4404 Memory Card  API
////////////////////////////////////////////////////////////////////////

long
SLE4404_Read_Memory(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,
	IN MM_ADDRESS aStartAddr,
	IN OUT LPDWORD pcbRecvLength);

long
SLE4404_Read_User_Memory(
    IN long hCard,
	OUT LPBYTE pbRecvBuffer,
	IN MM_ADDRESS aStartAddr,
	IN OUT LPDWORD pcbRecvLength);

long				
SLE4404_Compare_User_Code(
    IN long hCard,
	IN BYTE Code1,
	IN BYTE Code2);

long				
SLE4404_Compare_Memory_Code(
    IN long hCard,
	IN BYTE Code1,
	IN BYTE Code2,
	IN BYTE Code3,
	IN BYTE Code4);

long 
SLE4404_Erase_Memory(
    IN long hCard,	
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4404_Write_Memory(
    IN long hCard,
 	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4404_Write_MemoryA(
    IN long hCard,
 	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4404_Write_User_Memory(
    IN long hCard,
 	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4404_Write_User_MemoryA(
    IN long hCard,
 	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4404_Enter_Test_Mode(
	IN long hCard);

long
SLE4404_Exit_Test_Mode(
	IN long hCard);

long
SLE4404_Blow_Fuse(
    IN long hCard);

////////////////////////////////////////////////////////////////////////
//  SLE4406 Memory Card API
////////////////////////////////////////////////////////////////////////
long
SLE4406_Read_Memory(
    IN  long hCard,
	OUT LPBYTE pbRecvBuffer,
	IN  MM_ADDRESS aStartAddr,
	IN  OUT LPDWORD pcbRecvLength);

long
SLE4406_Read_Counter_Stages(
    IN  long hCard,
	OUT BYTE Stage[5]);

long
SLE4406_Write_Memory(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4406_Write_Counter_Stage(
    IN long hCard,	
	IN BYTE Stage,
	IN BYTE Data);

long
SLE4406_Reload(
    IN long hCard,
    IN BYTE BitAddr);


////////////////////////////////////////////////////////////////////////
//  SLE4436 Memory Card API
////////////////////////////////////////////////////////////////////////
long
SLE4436_Read_Memory(
    IN  long hCard,
	OUT LPBYTE pbRecvBuffer,
	IN  MM_ADDRESS aStartAddr,
	IN  OUT LPDWORD pcbRecvLength);

long
SLE4436_Read_Counter_Stages(
    IN  long hCard,
	OUT BYTE Stage[5]);

long
SLE4436_Write_Memory(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE4436_Write_Counter_Stage(
    IN long hCard,	
	IN BYTE Stage,
	IN BYTE Data);

long
SLE4436_Reload(
    IN long hCard,
    IN BYTE BitAddr);

long
SLE4436_Verify_Transport_Code(
    IN long hCard,
	IN BYTE Code1,
	IN BYTE Code2,
	IN BYTE Code3);

long
SLE4436_Authentication(
    IN long hCard,
	OUT BYTE ReturnCode[2],	
	IN BYTE Key,
	IN BYTE ClockPulse,
	IN BYTE Code[6]);

////////////////////////////////////////////////////////////////////////
//  SLE5536 Memory Card API
////////////////////////////////////////////////////////////////////////
long
SLE5536_Read_Memory(
    IN  long hCard,
	OUT LPBYTE pbRecvBuffer,
	IN  MM_ADDRESS aStartAddr,
	IN  OUT LPDWORD pcbRecvLength);

long
SLE5536_Read_Counter_Stages(
    IN  long hCard,
	OUT BYTE Stage[5]);

long
SLE5536_Write_Memory(
    IN long hCard,
	IN LPBYTE pbTransmitBuffer,
    IN MM_ADDRESS aStartAddr,
	IN DWORD TransmitLength);

long
SLE5536_Write_Counter_Stage(
    IN long hCard,	
	IN BYTE Stage,
	IN BYTE Data);

long
SLE5536_Reload(
    IN long hCard,
    IN BYTE BitAddr);

long
SLE5536_Verify_Transport_Code(
    IN long hCard,
	IN BYTE Code1,
	IN BYTE Code2,
	IN BYTE Code3);

long
SLE5536_Authentication(
    IN long hCard,
	OUT BYTE ReturnCode[2],	
	IN BYTE Key,
	IN BYTE ClockPulse,
	IN BYTE Code[6]);

////////////////////////////////////////////////////////////////////////
//  I2C Memory Card  API
////////////////////////////////////////////////////////////////////////

long
I2C_Read_Memory(
    IN long hCard,    
	IN BYTE ReadCommand, 
	IN MM_ADDRESS aStartAddr,
	OUT LPBYTE pbRecvBuffer,
	IN OUT LPDWORD pcbRecvLength,
	IN BYTE Dummy,
	IN BYTE AddrByteNum);

long
I2C_Write_Memory(
    IN long hCard,    
	IN BYTE WriteCommand, 
	IN MM_ADDRESS aStartAddr,
	OUT LPBYTE pbTransmitBuffer,
	IN DWORD TransmitLength,
	IN BYTE AddrByteNum);

long
I2C_SetMode(
    IN long hCard);

long
I2C_ClearMode(
    IN long hCard);


////////////////////////////////////////////////////////////////////////

//=================================================================//
//   
//    KIOSKMSR Application Programming Interface
//
//=================================================================//

#define MAX_MSR_DATA_LENGTH 256

typedef ULONG MSRHANDLE;
typedef MSRHANDLE *PMSRHANDLE, *LPMSRHANDLE;

typedef struct _MSR_DATA{

	// Output
	struct{

		// A buffer that receives the MSR Track01 data from the reader
		UCHAR Buffer[MAX_MSR_DATA_LENGTH];		

		// The length of the data of Track01 received from the reader
		ULONG BufferLength;

	} Track01;

	// Output
	struct{

		UCHAR Buffer[MAX_MSR_DATA_LENGTH];		

		ULONG BufferLength;

	} Track02;

	// Output
	struct{

		UCHAR Buffer[MAX_MSR_DATA_LENGTH];
		
		ULONG BufferLength;

	} Track03;

}MSR_DATA, *PMSR_DATA;


long
CasOpenMSR(
	IN  LPCSTR			szReader,			
    OUT LPMSRHANDLE		phMSR   
	);

long
CasReadMSR(
	IN MSRHANDLE		hMSR,
	IN OUT PMSR_DATA	pMSR_Data,
	IN ULONG			ulTimeout
	);

long
CasWaitForMSR(
	IN MSRHANDLE		hMSR,
	IN OUT PMSR_DATA	pMSR_Data
	);

long
CasDisableMSR(
	IN  MSRHANDLE		hMSR
	);

long
CasCloseMSR(
    IN  MSRHANDLE		hMSR
	);


#ifdef __cplusplus
}
#endif


#endif
            
